% Code for: Capital Reallocation and Aggregate Productivity
% R. Cooper & I. Schott
% Code version: September 2022

T               = 20000;
delx            = min(50,T*.1); % burn-in period
rng('default')
rng(1)
e               = randn(T,1); % innovation
e(1:delx)       = 0;
sig             = PARMS.sigA*sqrt(1-PARMS.rhoA^2);
eta             = zeros(nx,1);
eta(3)          = 1;
x0              = zeros(nx,1); 

[ytilde,xtilde] = simu_1st(gx,hx,eta,sig,x0,e);
yt              = bsxfun(@plus,yss',ytilde);
xt              = bsxfun(@plus,xss',xtilde);

% Back out policy functions
MU_n_t          = xt(:,1);
PHI_n_t         = xt(:,2);
A_t             = exp(xt(:,3));
B_t             = PARMS.F_upper;
K_t             = xt(:,4);

k_t             = yt(:,1:PARMS.N); % choice of new capital vector
k_t             = max(0,k_t);
PI_t            = yt(:,PARMS.N+1);
C_t             = yt(:,PARMS.N+2);
AC_t            = PI_t.^2/2.* B_t; % Total AC paid

%     trans       = repmat(PARMS.PP,[1, T+1]);
MU_a_t          = (PARMS.PP'*k_t'.^PARMS.ALPHA)';
outputA         = (PARMS.PP'*(PARMS.eps.*(k_t'.^PARMS.ALPHA)))';
PHI_a_t         = outputA - PARMS.meaneps.*MU_a_t(:);

% % Choices imply
outputNA        = PARMS.meaneps*MU_n_t + PHI_n_t;
Y_t             = A_t .* K_t.^PARMS.ALPHA .* (PI_t.*outputA + (1-PI_t).*outputNA) ;
%
SR_t            = A_t.* (PI_t.*outputA + (1-PI_t).*outputNA) ; % Solow residual

% Investment
I_t             = [PARMS.DELTA*steady.kstar; K_t(2:end) - (1-PARMS.DELTA)*K_t(1:end-1)];
